-- toyota hilux
GT_t.CH_t.bhd_somali_pickup_chassis = {
	life = 1.8,
	mass = 1660,
	length = 5.26,
	width = 1.76,
	max_road_velocity = 37,
	max_slope = 0.27,
	fordingDepth = 0.7,
	engine_power = 144,
	max_vert_obstacle = 0.45,
	max_acceleration = 2.925926,
	min_turn_radius = 5.9,
	X_gear_1 = 1.69,
	Y_gear_1 = 0,
	Z_gear_1 = 0.83,
	X_gear_2 = -1.5,
	Y_gear_2 = 0,
	Z_gear_2 = 0.83,
	chassisDeepening = 0.02,
	gear_type = GT_t.GEAR_TYPES.WHEELS,
	r_max = 0.35,
	trace_width = 0.223,
	armour_thickness = 0.001,
	
	COM_pos = {0.0, 0.8, 0.0},
}

local wheelPost = {
	BasicLength = 0.18,
	ReduceLength = 0.0,
	MinLength = 0.0,
	MaxLength = 0.18,
	SpringForceFactor = 200000.0,
	SpringForceFactorRate = 1.1,
	StaticForce = 200.0,
	DirectDamperForceFactor = 8500.0,
	BackDamperForceFactor = 7500.0,
	
	BS_BasicLength = 0.05, -- last 5 cm of compresstion bumpstop is engaged
	BS_SpringForceFactor = 10000.0,
	BS_DirectDamperForceFactor = 20000.0,
	
	IsCaterpillar = false,
	--MOI = 11.55,
	steering = true,
	
	pos = {}
}
local positions = {
	{1.69, 0.0, -0.83},
	{1.69, 0.0, 0.83},
	{-1.5, 0.0, -0.83},
	{-1.5, 0.0, 0.83},
}
GT_t.CH_t.bhd_somali_pickup_chassis.wheelPosts = {}
for i = 1, 4 do
	GT_t.CH_t.bhd_somali_pickup_chassis.wheelPosts[i] = {}
	set_recursive_metatable(GT_t.CH_t.bhd_somali_pickup_chassis.wheelPosts[i], wheelPost)
	set_recursive_metatable(GT_t.CH_t.bhd_somali_pickup_chassis.wheelPosts[i].pos, positions[i])
end
GT_t.CH_t.bhd_somali_pickup_chassis.wheelPosts[3].steering = false
GT_t.CH_t.bhd_somali_pickup_chassis.wheelPosts[4].steering = false